<?php

namespace App\Models;

class City extends Eloquent {

	protected $table = 'cities';
	public $timestamps = true;
	protected $fillable = array('governorate_id', 'name');

	public function clients()
	{
		return $this->hasMany('App\Models\Client');
	}

	public function losts()
	{
		return $this->hasMany('App\Models\Lost');
	}

	public function governorate()
	{
		return $this->belongsTo('App\Models\Governorate');
	}

}