<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Passenger extends Model 
{

    protected $table = 'passengers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('first_name_fa', 'first_name_en', 'last_name_fa', 'last_name_en', 'gender', 'birth_date', 'national_code', 'uuid', 'client_id');

    public function client()
    {
        return $this->hasOne('App\Client', 'client_id');
    }

    public function bus_order_items()
    {
        return $this->belongsToMany('App\BusOrderItem');
    }

}