<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('token', 'agent', 'attributes');

	public function passenger()
	{
		return $this->belongsTo('App\Passenger');
	}

	public function orders()
	{
		return $this->hasMany('App\Order');
	}

}