<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLocationsTable extends Migration {

	public function up()
	{
		Schema::create('locations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('city', 200)->nullable()->index();
			$table->string('country', 200)->nullable()->index();
			$table->string('state', 200)->nullable()->index();
			$table->text('address')->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('locations');
	}
}