<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoresTable extends Migration {

	public function up()
	{
		Schema::create('stores', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->string('name', 250)->nullable()->index();
			$table->text('description')->nullable();
			$table->string('img_cover', 150)->nullable()->index();
			$table->string('logo', 150)->nullable();
			$table->text('tags')->nullable();
			$table->string('slug', 200)->nullable();
			$table->decimal('note', 8,2)->nullable()->default('0');
			$table->json('gallery')->nullable();
			$table->boolean('activation')->nullable()->default(0);
			$table->bigInteger('user_id')->unsigned();
			$table->integer('feedback_id')->unsigned();
			$table->integer('store_payment_id')->unsigned();
			$table->integer('store_location_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('stores');
	}
}