<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255)->nullable()->index();
			$table->text('description')->nullable();
			$table->string('tags', 255)->nullable()->index();
			$table->string('dimension', 100)->nullable();
			$table->string('weight', 100)->nullable();
			$table->decimal('price', 8,2)->nullable()->index();
			$table->integer('stock')->nullable()->default('0');
			$table->string('condition', 50)->nullable();
			$table->boolean('publied')->default(0);
			$table->string('reference', 150)->nullable()->index();
			$table->string('slug', 250)->nullable();
			$table->bigInteger('store_id')->unsigned();
			$table->integer('image_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}