<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('reference', 100)->nullable();
			$table->bigInteger('store_id')->unsigned();
			$table->integer('command_id')->unsigned();
			$table->decimal('total', 8,2);
			$table->integer('store_stripe_id')->unsigned()->nullable();
			$table->integer('store_paypal_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}