<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePersonalSituationsTable extends Migration {

	public function up()
	{
		Schema::create('personal_situations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->tinyInteger('children_number');
			$table->boolean('lives_with_children');
			$table->boolean('has_children_custody');
			$table->boolean('children_injoint_custody');
			$table->integer('activity_status_index');
			$table->string('job', 256);
			$table->date('unemployment_duration');
			$table->integer('studylevel_index');
			$table->boolean('school_repetition');
			$table->boolean('grade_jump');
			$table->integer('income_index');
			$table->integer('current_pet_index');
			$table->integer('former_pet_index');
			$table->date('recent_travel_date');
			$table->string('travel_country', 256);
			$table->bigInteger('travel_duration_in_days');
			$table->string('lived_abroad_country', 256);
			$table->date('lived_aborad_return_date');
			$table->bigInteger('lived_aborad_duration_in_days');
			$table->string('current_country', 256);
			$table->date('smoking_habit_date');
			$table->integer('smoking_amount');
			$table->integer('last_smoking_index');
			$table->string('hobby_index', 256);
			$table->integer('sport_id');
		});
	}

	public function down()
	{
		Schema::drop('personal_situations');
	}
}