<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ClinicalSign extends Eloquent {

	protected $table = 'clinical_signs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function patient()
	{
		return $this->belongsTo('Patient');
	}

	public function question_overrides()
	{
		return $this->hasMany('QuestionOverride');
	}

	public function physical_exam_overrides()
	{
		return $this->hasMany('PhysicalExamOverride');
	}

}