<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PhysicalExamOverride extends Eloquent {

	protected $table = 'physical_exam_overrides';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function clinical_sign()
	{
		return $this->belongsTo('ClinicalSign');
	}

	public function exams()
	{
		return $this->hasMany('Exam');
	}

}