<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBusinessProfilesTable extends Migration {

	public function up()
	{
		Schema::create('business_profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('administrator_user_id')->unique()->unsigned();
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('phone_number', 15);
			$table->string('abn', 25);
			$table->boolean('verified');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('business_profiles');
	}
}