<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFileRemindersTable extends Migration {

	public function up()
	{
		Schema::create('file_reminders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('file_id')->unsigned();
			$table->date('date_of_reminder');
			$table->string('description', 1000);
			$table->integer('service_profile_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('file_reminders');
	}
}