<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFilesTable extends Migration {

	public function up()
	{
		Schema::create('files', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('file_type_id')->unsigned();
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('service_profile_id')->unsigned();
			$table->string('name', 255);
			$table->integer('size');
			$table->string('encryption_algorithm', 15)->nullable();
			$table->text('compression_options')->nullable();
			$table->string('compression_algorithm', 15)->nullable();
			$table->text('encryption_options')->nullable();
			$table->string('storage_provider', 15);
			$table->string('storage_path', 300);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('files');
	}
}