<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfileFieldsTable extends Migration {

	public function up()
	{
		Schema::create('profile_fields', function(Blueprint $table) {
			$table->increments('id');
			$table->string('label', 255);
			$table->enum('type', array('text', 'address', 'date', 'select'));
			$table->text('options');
			$table->boolean('show_in_leads');
			$table->integer('profile_type_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('profile_fields');
	}
}