<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceProfileAreaTable extends Migration {

	public function up()
	{
		Schema::create('service_profile_area', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('service_profile_id')->unsigned();
			$table->enum('type', array('postcode_radius', 'state', 'country'));
			$table->decimal('latitude', 9,6)->nullable();
			$table->decimal('longitude', 9,6)->nullable();
			$table->string('state', 255)->nullable();
			$table->string('country', 255)->nullable();
			$table->integer('subscription_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('service_profile_area');
	}
}