<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceProfilesTable extends Migration {

	public function up()
	{
		Schema::create('service_profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('business_profile_id')->unsigned();
			$table->integer('service_type_id')->unsigned();
			$table->string('address_line_1', 255);
			$table->string('address_line_2', 255)->nullable();
			$table->string('address_city', 255);
			$table->string('address_state', 255);
			$table->string('address_postcode', 10);
			$table->integer('years_offering_service_for');
			$table->string('phone_number', 20);
			$table->string('email', 255);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('service_profiles');
	}
}