<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('billing_details_id')->unsigned();
			$table->timestamps();
			$table->string('plan', 20);
			$table->smallInteger('interval_units');
			$table->enum('interval_type', array('month', 'year'));
			$table->integer('fee_cents');
			$table->date('next_payment_date');
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}