<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('email', 255)->unique();
			$table->string('password', 60);
			$table->string('address_line_1', 255);
			$table->string('address_line_2', 255)->nullable();
			$table->string('address_city', 255);
			$table->string('address_state', 30);
			$table->string('address_postcode', 15);
			$table->decimal('latitude', 9,6);
			$table->decimal('longitude', 9,6);
			$table->boolean('allow_sharing');
			$table->rememberToken('remember_token');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}