<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMilestoneTable extends Migration {

	public function up()
	{
		Schema::create('milestone', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->text('description')->nullable();
			$table->integer('type_id');
			$table->string('sub_type');
			$table->integer('created_by')->nullable();
			$table->integer('updated_by')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('milestone');
	}
}