<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('pocket_id');
			$table->string('payload', 50);
			$table->string('sender_id', 50);
			$table->string('receiver_id', 50);
			$table->string('pockets_name', 300);
			$table->boolean('isSharePocket');
			$table->boolean('isArchived');
			$table->boolean('isFriendRequest');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}