<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Country extends Model 
{

    protected $table = 'countries';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function images()
    {
        return $this->morphMany('Image');
    }

    public function countryTranslations()
    {
        return $this->hasMany('CountryTranslation');
    }

}