<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Branch extends Eloquent {

	protected $table = 'branches';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function branchTranslations()
	{
		return $this->hasMany('BranchTranslation');
	}

	public function workTimes()
	{
		return $this->hasMany('WorkTime');
	}

	public function phones()
	{
		return $this->hasMany('Phone');
	}

	public function emails()
	{
		return $this->hasMany('Email');
	}

}