<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Director extends Eloquent {

	protected $table = 'directors';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function directorTranslations()
	{
		return $this->hasMany('DirectorTranslation');
	}

	public function jobTitle()
	{
		return $this->hasOne('JobTitle');
	}

	public function chairManSpeech()
	{
		return $this->hasOne('Speech');
	}

}