<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class JobTitle extends Eloquent {

	protected $table = 'job_titles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function jobTitleTranslations()
	{
		return $this->hasMany('JobTitleTranslation');
	}

	public function director()
	{
		return $this->belongsTo('Director');
	}

}