<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProjectComment extends Eloquent {

	protected $table = 'project_comment';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('project_id', 'massage', 'created_by');

	public function project()
	{
		return $this->belongsTo('Project', 'project_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'created_by');
	}

}