<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Task extends Eloquent {

	protected $table = 'task';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('project_id', 'created_by', 'title', 'details', 'status', 'due_date', 'total_time');

	public function comments()
	{
		return $this->hasMany('TaskComment', 'task_id');
	}

	public function project()
	{
		return $this->belongsTo('Project', 'project_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'created_by');
	}

	public function assigns()
	{
		return $this->hasMany('AssignTo', 'task_id');
	}

}