<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'user';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function projects()
	{
		return $this->belongsToMany('Project', 'user_project', 'user_id', 'project_id');
	}

}