<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('payment_history', function(Blueprint $table) {
			$table->foreign('enrollment_id')->references('id')->on('enrollment')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment_history', function(Blueprint $table) {
			$table->foreign('payment_method_id')->references('id')->on('payment_method')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('enrollment', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('enrollment', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branch_details')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('enrollment', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses_details')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment_method', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('payment_method')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('payment_history', function(Blueprint $table) {
			$table->dropForeign('payment_history_enrollment_id_foreign');
		});
		Schema::table('payment_history', function(Blueprint $table) {
			$table->dropForeign('payment_history_payment_method_id_foreign');
		});
		Schema::table('enrollment', function(Blueprint $table) {
			$table->dropForeign('enrollment_user_id_foreign');
		});
		Schema::table('enrollment', function(Blueprint $table) {
			$table->dropForeign('enrollment_branch_id_foreign');
		});
		Schema::table('enrollment', function(Blueprint $table) {
			$table->dropForeign('enrollment_course_id_foreign');
		});
		Schema::table('payment_method', function(Blueprint $table) {
			$table->dropForeign('payment_method_parent_id_foreign');
		});
	}
}