<?php

namespace App\Models;

class Factfind extends Eloquent {

	protected $table = 'factfinds';
	public $timestamps = true;

	public function asesor()
	{
		return $this->belongsTo('Asesor', 'id_asesor');
	}

	public function cliente()
	{
		return $this->hasOne('Cliente', 'id_cliente');
	}

	public function empleo()
	{
		return $this->hasOne('App\Models\Empleo', 'id_empleo');
	}

	public function gatos()
	{
		return $this->hasOne('App\Models\GastoMensual', 'id_gasto_mensual');
	}

	public function patrimonio_proteccion()
	{
		return $this->hasOne('App\Models\PatrimonioProteccion', 'id_patrimonio_proteccion');
	}

	public function prioridad_riesgo_inversion()
	{
		return $this->hasOne('App\Models\PrioridadRiesgoInversion', 'id_prioridad_riesgo_inversion');
	}

	public function propiedades()
	{
		return $this->hasMany('App\Models\Propiedad', 'id_factfind');
	}

	public function ahorros()
	{
		return $this->hasMany('App\Models\Ahorro', 'id_factfind');
	}

	public function prestamos_deudas()
	{
		return $this->hasMany('App\Models\PrestamoDeuda', 'id_factfind');
	}

	public function referidos()
	{
		return $this->hasMany('App\Models\Referido', 'id_factfind');
	}

}