<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('account_no')->references('no')->on('accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('feedsactivity', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('feedsactivity', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('forms', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('form_submissions', function(Blueprint $table) {
			$table->foreign('form_id')->references('id')->on('forms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('form_submissions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('form_submissions', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_account_no_foreign');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_user_id_foreign');
		});
		Schema::table('feedsactivity', function(Blueprint $table) {
			$table->dropForeign('feedsactivity_user_id_foreign');
		});
		Schema::table('feedsactivity', function(Blueprint $table) {
			$table->dropForeign('feedsactivity_contact_id_foreign');
		});
		Schema::table('forms', function(Blueprint $table) {
			$table->dropForeign('forms_user_id_foreign');
		});
		Schema::table('form_submissions', function(Blueprint $table) {
			$table->dropForeign('form_submissions_form_id_foreign');
		});
		Schema::table('form_submissions', function(Blueprint $table) {
			$table->dropForeign('form_submissions_user_id_foreign');
		});
		Schema::table('form_submissions', function(Blueprint $table) {
			$table->dropForeign('form_submissions_contact_id_foreign');
		});
	}
}