<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('admin_role_permissions', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('admin_roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('admin_role_permissions', function(Blueprint $table) {
			$table->foreign('route_id')->references('id')->on('route_details')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('route_details', function(Blueprint $table) {
			$table->foreign('menu_id')->references('id')->on('menus')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('businesses', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('businesses', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('role_permissions', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('role_permissions', function(Blueprint $table) {
			$table->foreign('route_id')->references('id')->on('route_details')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('business_users', function(Blueprint $table) {
			$table->foreign('business_id')->references('id')->on('businesses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('business_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('business_id')->references('id')->on('businesses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoice_items', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('invoices')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoice_items', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('labels', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('labels', function(Blueprint $table) {
			$table->foreign('business_id')->references('id')->on('businesses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('label_values', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('label_values', function(Blueprint $table) {
			$table->foreign('business_id')->references('id')->on('businesses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('label_values', function(Blueprint $table) {
			$table->foreign('label_id')->references('id')->on('labels')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('logs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('logs', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('uploads', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('uploads', function(Blueprint $table) {
			$table->foreign('business_id')->references('id')->on('businesses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('upload_label_values', function(Blueprint $table) {
			$table->foreign('upload_id')->references('id')->on('uploads')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('upload_label_values', function(Blueprint $table) {
			$table->foreign('label_value_id')->references('id')->on('label_values')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('file_categories', function(Blueprint $table) {
			$table->foreign('upload_id')->references('id')->on('uploads')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('file_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('admin_role_permissions', function(Blueprint $table) {
			$table->dropForeign('admin_role_permissions_role_id_foreign');
		});
		Schema::table('admin_role_permissions', function(Blueprint $table) {
			$table->dropForeign('admin_role_permissions_route_id_foreign');
		});
		Schema::table('route_details', function(Blueprint $table) {
			$table->dropForeign('route_details_menu_id_foreign');
		});
		Schema::table('businesses', function(Blueprint $table) {
			$table->dropForeign('businesses_account_id_foreign');
		});
		Schema::table('businesses', function(Blueprint $table) {
			$table->dropForeign('businesses_package_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_account_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_account_id_foreign');
		});
		Schema::table('role_permissions', function(Blueprint $table) {
			$table->dropForeign('role_permissions_role_id_foreign');
		});
		Schema::table('role_permissions', function(Blueprint $table) {
			$table->dropForeign('role_permissions_route_id_foreign');
		});
		Schema::table('business_users', function(Blueprint $table) {
			$table->dropForeign('business_users_business_id_foreign');
		});
		Schema::table('business_users', function(Blueprint $table) {
			$table->dropForeign('business_users_user_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_account_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_business_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_account_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_account_id_foreign');
		});
		Schema::table('invoice_items', function(Blueprint $table) {
			$table->dropForeign('invoice_items_invoice_id_foreign');
		});
		Schema::table('invoice_items', function(Blueprint $table) {
			$table->dropForeign('invoice_items_item_id_foreign');
		});
		Schema::table('labels', function(Blueprint $table) {
			$table->dropForeign('labels_account_id_foreign');
		});
		Schema::table('labels', function(Blueprint $table) {
			$table->dropForeign('labels_business_id_foreign');
		});
		Schema::table('label_values', function(Blueprint $table) {
			$table->dropForeign('label_values_account_id_foreign');
		});
		Schema::table('label_values', function(Blueprint $table) {
			$table->dropForeign('label_values_business_id_foreign');
		});
		Schema::table('label_values', function(Blueprint $table) {
			$table->dropForeign('label_values_label_id_foreign');
		});
		Schema::table('logs', function(Blueprint $table) {
			$table->dropForeign('logs_user_id_foreign');
		});
		Schema::table('logs', function(Blueprint $table) {
			$table->dropForeign('logs_account_id_foreign');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->dropForeign('suppliers_account_id_foreign');
		});
		Schema::table('uploads', function(Blueprint $table) {
			$table->dropForeign('uploads_account_id_foreign');
		});
		Schema::table('uploads', function(Blueprint $table) {
			$table->dropForeign('uploads_business_id_foreign');
		});
		Schema::table('upload_label_values', function(Blueprint $table) {
			$table->dropForeign('upload_label_values_upload_id_foreign');
		});
		Schema::table('upload_label_values', function(Blueprint $table) {
			$table->dropForeign('upload_label_values_label_value_id_foreign');
		});
		Schema::table('file_categories', function(Blueprint $table) {
			$table->dropForeign('file_categories_upload_id_foreign');
		});
		Schema::table('file_categories', function(Blueprint $table) {
			$table->dropForeign('file_categories_category_id_foreign');
		});
	}
}