<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUploadsTable extends Migration {

	public function up()
	{
		Schema::create('uploads', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('account_id')->unsigned();
			$table->integer('business_id')->unsigned();
			$table->string('folder', 255);
			$table->string('file_name', 255);
			$table->string('name', 255);
			$table->string('extention', 255);
			$table->string('file_mime', 255);
			$table->string('ocr_xml', 255);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('uploads');
	}
}