<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Plan extends Eloquent {

	protected $table = 'plans';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description', 'price', 'currency');

	public function dreams()
	{
		return $this->hasMany('App\Models\Dream');
	}

}