<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('customer_address_default')->references('id')->on('customer_addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('customer_saved_cards')->references('id')->on('customer_cards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('active_order')->references('order_active')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customer_cards', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customer_addresses', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('order_owner')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('order_delivery')->references('id')->on('customer_addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_customer_address_default_foreign');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_customer_saved_cards_foreign');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_active_order_foreign');
		});
		Schema::table('customer_cards', function(Blueprint $table) {
			$table->dropForeign('customer_cards_customer_id_foreign');
		});
		Schema::table('customer_addresses', function(Blueprint $table) {
			$table->dropForeign('customer_addresses_customer_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_order_owner_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_order_delivery_foreign');
		});
	}
}