<?php

namespace Fusionalliance\Controlforms;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FormSubmission extends Eloquent {

	protected $table = 'form_submissions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function controlForm()
	{
		return $this->belongsTo('ControlForm');
	}

	public function formUser()
	{
		return $this->belongsTo('FormUser');
	}

	public function formValues()
	{
		return $this->hasMany('FormValue');
	}

	public function formMetaFieldValues()
	{
		return $this->hasMany('FormMetaFieldValue');
	}

	public function formMetaFields()
	{
		return $this->hasManyThrough('FormMetaField', 'FormMetaFieldValue');
	}

}