<?php

namespace App\Models\Accreditation;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Accreditation extends Eloquent {

	protected $table = 'accreditations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getActionFacts()
	{
		return $this->belongsTo('Events');
	}

	public function getChallenge()
	{
		return $this->belongsTo('Challenge');
	}

	public function getQuiz()
	{
		return $this->belongsTo('Quiz');
	}

}