<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClassesTable extends Migration {

	public function up()
	{
		Schema::create('classes', function(Blueprint $table) {
			$table->increments('id', true);
			$table->integer('course_id')->unsigned();
			$table->string('topic');
			$table->text('description')->nullable();
			$table->string('audio_path')->nullable();
			$table->string('pdf_path')->nullable();
			$table->boolean('free')->nullable()->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('classes');
	}
}