<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEnrolledCoursesTable extends Migration {

	public function up()
	{
		Schema::create('enrolled_courses', function(Blueprint $table) {
			$table->increments('id', true);
			$table->integer('course_id')->unsigned();
			$table->integer('student_id')->unsigned();
			$table->timestamp('certified_at')->nullable();
			$table->timestamp('expires_at')->nullable();
			$table->timestamps();
			$table->integer('order_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('enrolled_courses');
	}
}