<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketsTable extends Migration {

	public function up()
	{
		Schema::create('tickets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('representative_id')->nullable();
			$table->integer('company_id')->unsigned()->nullable();
			$table->integer('operator_id')->unsigned()->nullable();
			$table->integer('client_id')->unsigned()->nullable();
			$table->string('perriorty', 255)->nullable();
			$table->integer('ticket_category_id')->unsigned()->nullable();
			$table->integer('user_id')->nullable();
			$table->longText('description')->nullable();
			$table->string('status', 255)->nullable();
			$table->string('file', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tickets');
	}
}