<?php

namespace Models/Company;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'companies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function company_country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function company_city()
    {
        return $this->belongsTo('City', 'city_id');
    }

}