<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('calculator_categories', function(Blueprint $table) {
			$table->foreign('calculator_id')->references('id')->on('calculators')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('calculator_questions', function(Blueprint $table) {
			$table->foreign('calculator_id')->references('id')->on('calculators')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('calculator_questions', function(Blueprint $table) {
			$table->foreign('calculator_category_id')->references('id')->on('calculator_categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('calculator_questions', function(Blueprint $table) {
			$table->foreign('calculator_invoice_category_id')->references('id')->on('calculator_invoice_categories')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('calculator_translations', function(Blueprint $table) {
			$table->foreign('calculator_id')->references('id')->on('calculators')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('calculator_category_translations', function(Blueprint $table) {
			$table->foreign('calculator_category_id')->references('id')->on('calculator_categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('calculator_applications', function(Blueprint $table) {
			$table->foreign('calculator_id')->references('id')->on('calculators')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('calculator_question_translations', function(Blueprint $table) {
			$table->foreign('calculator_question_id')->references('id')->on('calculator_questions')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('calculator_question_items', function(Blueprint $table) {
			$table->foreign('calculator_question_id')->references('id')->on('calculator_questions')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('calculator_question_item_translations', function(Blueprint $table) {
			$table->foreign('calculator_question_item_id')->references('id')->on('calculators')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('calculator_invoice_categories', function(Blueprint $table) {
			$table->foreign('calculator_id')->references('id')->on('calculators')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('calculator_invoice_category_translations', function(Blueprint $table) {
			$table->foreign('calculator_invoice_category_id')->references('id')->on('calculator_invoice_categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('calculator_categories', function(Blueprint $table) {
			$table->dropForeign('calculator_categories_calculator_id_foreign');
		});
		Schema::table('calculator_questions', function(Blueprint $table) {
			$table->dropForeign('calculator_questions_calculator_id_foreign');
		});
		Schema::table('calculator_questions', function(Blueprint $table) {
			$table->dropForeign('calculator_questions_calculator_category_id_foreign');
		});
		Schema::table('calculator_questions', function(Blueprint $table) {
			$table->dropForeign('calculator_questions_calculator_invoice_category_id_foreign');
		});
		Schema::table('calculator_translations', function(Blueprint $table) {
			$table->dropForeign('calculator_translations_calculator_id_foreign');
		});
		Schema::table('calculator_category_translations', function(Blueprint $table) {
			$table->dropForeign('calculator_category_translations_calculator_category_id_foreign');
		});
		Schema::table('calculator_applications', function(Blueprint $table) {
			$table->dropForeign('calculator_applications_calculator_id_foreign');
		});
		Schema::table('calculator_question_translations', function(Blueprint $table) {
			$table->dropForeign('calculator_question_translations_calculator_question_id_foreign');
		});
		Schema::table('calculator_question_items', function(Blueprint $table) {
			$table->dropForeign('calculator_question_items_calculator_question_id_foreign');
		});
		Schema::table('calculator_question_item_translations', function(Blueprint $table) {
			$table->dropForeign('calculator_question_item_translations_calculator_question_item_id_foreign');
		});
		Schema::table('calculator_invoice_categories', function(Blueprint $table) {
			$table->dropForeign('calculator_invoice_categories_calculator_id_foreign');
		});
		Schema::table('calculator_invoice_category_translations', function(Blueprint $table) {
			$table->dropForeign('calculator_invoice_category_translations_calculator_invoice_category_id_foreign');
		});
	}
}