<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlansTable extends Migration {

	public function up()
	{
		Schema::create('plans', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('slug');
			$table->string('name');
			$table->text('description');
			$table->tinyInteger('is_active')->default('0');
			$table->integer('price');
			$table->bigInteger('currency_id')->unsigned();
			$table->tinyInteger('trial_period');
			$table->string('trial_interval')->default('day');
			$table->tinyInteger('invoice_period');
			$table->string('invoice_interval')->default('month');
			$table->smallInteger('grace_period');
			$table->string('grace_interval')->default('day');
		});
	}

	public function down()
	{
		Schema::drop('plans');
	}
}