<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMitraTable extends Migration {

	public function up()
	{
		Schema::create('mitra', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('nama', 100);
			$table->integer('provinsi_id');
			$table->integer('kota_kab_id');
			$table->integer('kecamatan_id');
			$table->integer('kelurahan_id');
			$table->string('penanggung_jawab', 100)->nullable();
			$table->string('alamat', 255);
			$table->enum('status', array('Aktif', 'TidakAktif'));
		});
	}

	public function down()
	{
		Schema::drop('mitra');
	}
}