<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRoomsTable extends Migration {

	public function up()
	{
		Schema::create('rooms', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 255);
			$table->integer('no_of_person');
			$table->string('price', 255);
			$table->integer('category_id')->unsigned();
			$table->string('description', 255);
			$table->date('open_at');
			$table->date('close_at');
			$table->tinyInteger('Status');
			$table->integer('branch_id')->unsigned();
			$table->text('policy');
			$table->json('tags');
			$table->string('active', 100);
		});
	}

	public function down()
	{
		Schema::drop('rooms');
	}
}