<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('User', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->string('user_name', 255)->unique();
			$table->string('email', 255)->unique();
			$table->string('name', 255);
			$table->string('password', 255);
			$table->tinyInteger('Status');
			$table->tinyInteger('role_id');
			$table->string('phone', 255);
			$table->string('email_verified', 255);
			$table->string('fcm_token', 255);
		});
	}

	public function down()
	{
		Schema::drop('User');
	}
}