<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('business', function(Blueprint $table) {
			$table->foreign('business_category_id')->references('id')->on('business_category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('business', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('branch', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branch')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gallary', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('room_feature', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('room_feature', function(Blueprint $table) {
			$table->foreign('feature_id')->references('id')->on('feature')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('booking', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('booking', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Favorite', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Favorite', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('review', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('review', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('room_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('service')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('room_services', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('translate', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('business', function(Blueprint $table) {
			$table->dropForeign('business_business_category_id_foreign');
		});
		Schema::table('business', function(Blueprint $table) {
			$table->dropForeign('business_user_id_foreign');
		});
		Schema::table('branch', function(Blueprint $table) {
			$table->dropForeign('branch_user_id_foreign');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->dropForeign('rooms_category_id_foreign');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->dropForeign('rooms_branch_id_foreign');
		});
		Schema::table('gallary', function(Blueprint $table) {
			$table->dropForeign('gallary_room_id_foreign');
		});
		Schema::table('room_feature', function(Blueprint $table) {
			$table->dropForeign('room_feature_room_id_foreign');
		});
		Schema::table('room_feature', function(Blueprint $table) {
			$table->dropForeign('room_feature_feature_id_foreign');
		});
		Schema::table('booking', function(Blueprint $table) {
			$table->dropForeign('booking_user_id_foreign');
		});
		Schema::table('booking', function(Blueprint $table) {
			$table->dropForeign('booking_room_id_foreign');
		});
		Schema::table('Favorite', function(Blueprint $table) {
			$table->dropForeign('Favorite_user_id_foreign');
		});
		Schema::table('Favorite', function(Blueprint $table) {
			$table->dropForeign('Favorite_room_id_foreign');
		});
		Schema::table('review', function(Blueprint $table) {
			$table->dropForeign('review_user_id_foreign');
		});
		Schema::table('review', function(Blueprint $table) {
			$table->dropForeign('review_room_id_foreign');
		});
		Schema::table('room_services', function(Blueprint $table) {
			$table->dropForeign('room_services_service_id_foreign');
		});
		Schema::table('room_services', function(Blueprint $table) {
			$table->dropForeign('room_services_room_id_foreign');
		});
		Schema::table('translate', function(Blueprint $table) {
			$table->dropForeign('translate_language_id_foreign');
		});
	}
}