<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Business extends Model 
{

    protected $table = 'business';
    public $timestamps = true;
    protected $fillable = array('id', 'name', 'business_category_id', 'location', 'phone', 'attachment', 'user_id', 'open_at', 'close_st', 'max_people', 'fees');

    public function users()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function Category()
    {
        return $this->belongsTo('BusinessCategory', 'business_category_id');
    }

}