<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingTable extends Migration {

	public function up()
	{
		Schema::create('booking', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->date('Date');
			$table->time('date_from');
			$table->time('date_to');
			$table->integer('user_id')->unsigned();
			$table->integer('room_id')->unsigned();
			$table->string('type', 255);
			$table->tinyInteger('Status');
			$table->integer('totla_price');
			$table->string('file', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('booking');
	}
}