<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uid');
			$table->tinyInteger('status')->unsigned();
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->bigInteger('billing_address_id')->unsigned()->nullable();
			$table->integer('shipping_address_id')->unsigned()->nullable();
			$table->integer('currency_id')->unsigned();
			$table->double('sub_total', 12,4)->default('0.0');
			$table->double('tax', 12,4)->default('0.0');
			$table->double('tax_rate', 6,3)->default('0.0');
			$table->double('total', 12,4)->default('0.0');
			$table->double('discount', 12,4)->default('0.0');
			$table->double('grand_total', 12,4)->default('0.0');
			$table->smallInteger('installment')->unsigned()->default('1');
			$table->json('response')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}