<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMatchsTable extends Migration {

	public function up()
	{
		Schema::create('matchs', function(Blueprint $table) {
			$table->increments('id');
			$table->datetime('start_dateTime');
			$table->datetime('end_dateTime');
			$table->integer('first_team')->unsigned();
			$table->integer('second_team')->unsigned();
			$table->integer('first_team_score')->unsigned()->default('0');
			$table->integer('second_team_score')->unsigned()->default('0');
			$table->integer('tournament_id')->unsigned()->default('0');
			$table->string('winner', 100);
			$table->integer('status')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('matchs');
	}
}